<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>
<xsl:template match="/">
  <xsl:for-each select="root/sourceObject">
    <xsl:if test="name and normalize-space(name)!=''">
      <xsl:text>name=</xsl:text>
      <xsl:value-of select="normalize-space(name)"/>
      <xsl:text>&#xa;</xsl:text>
    </xsl:if>
<xsl:if test="container and folder and normalize-space(container)!=''">
    <xsl:text>path=</xsl:text>
    <xsl:value-of select="concat('wtpub', '\', normalize-space(container), '\', normalize-space(folder))"/>  
    <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:if test="objectType">
    <xsl:text>objType=</xsl:text>
      <xsl:choose> 
        <xsl:when test="normalize-space(objectType)='Assembly'">
          <xsl:value-of select="20"/>
        </xsl:when>
        <xsl:when test= "normalize-space(objectType)='CAD Part'">
          <xsl:value-of select="10"/> 
        </xsl:when>
        <xsl:when test= "normalize-space(objectType)='Drawing'"> 
          <xsl:value-of select="30"/> 
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="1"/> 
        </xsl:otherwise>
      </xsl:choose> 
      <xsl:text>&#xa;</xsl:text>
</xsl:if>
<xsl:if test="lifeCycleState">
    <xsl:text>status=</xsl:text>
      <xsl:choose>
        <xsl:when test="normalize-space(lifeCycleState)='In Work'"> 
          <xsl:value-of select="3"/> 
        </xsl:when>
        <xsl:when test="normalize-space(lifeCycleState)='Released'"> 
          <xsl:value-of select="2"/> 
        </xsl:when>
        <xsl:when test="normalize-space(lifeCycleState)='Under Review'"> 
          <xsl:value-of select="4"/> 
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="-1"/> 
        </xsl:otherwise>
      </xsl:choose> 
      <xsl:text>&#xa;</xsl:text> 
</xsl:if>
<xsl:choose>
<xsl:when test="(version and iteration) and (normalize-space(version) !='') and (normalize-space(iteration) !='')">
      <xsl:text>P:REVISON=</xsl:text>
      <xsl:value-of select="concat(normalize-space(version), '.', normalize-space(iteration))"/>
      <xsl:text>&#xa;</xsl:text> 
</xsl:when>
<xsl:when test="(((version and iteration) and (normalize-space(version) !='') and (normalize-space(iteration) ='')) or ((version and (not(iteration))) and (normalize-space(version) !='' )))">
      <xsl:text>P:REVISON=</xsl:text>
      <xsl:value-of select="normalize-space(version)"/>
      <xsl:text>&#xa;</xsl:text> 
</xsl:when>
<xsl:when test="(((version and iteration) and (normalize-space(version) ='') and (normalize-space(iteration) !='')) or ((not(version) and iteration) and (normalize-space(iteration) !='' )))">
      <xsl:text>P:REVISON=</xsl:text>
      <xsl:value-of select="normalize-space(iteration)"/>
      <xsl:text>&#xa;</xsl:text> 
</xsl:when>
<xsl:otherwise>
</xsl:otherwise>
</xsl:choose>
 <xsl:if test="ibas/MASSE and normalize-space(ibas/MASSE)!=''">
        <xsl:text>P:MASSE=</xsl:text>
        <xsl:value-of select="normalize-space(ibas/MASSE)"/>
<xsl:text>&#xa;</xsl:text> 
      </xsl:if>
<xsl:if test="thumbnail/thumbnailData and normalize-space(thumbnail/thumbnailData)!=''">
        <xsl:text>thumbnail=</xsl:text>
        <xsl:value-of select="normalize-space(thumbnail/thumbnailData)"/>
<xsl:text>&#xa;</xsl:text> 
      </xsl:if>	  
  <xsl:if test="contains(name,'.asm') or contains(name,'.prt')">
<xsl:choose>
<xsl:when test="(ibas/DESCRIPTION_1_EN and ibas/DESCRIPTION_2_EN) and (normalize-space(ibas/DESCRIPTION_1_EN) !='') and (normalize-space(ibas/DESCRIPTION_2_EN) !='')">
<xsl:text>title_en=</xsl:text>
<xsl:value-of select="concat(normalize-space(ibas/DESCRIPTION_1_EN),'_', normalize-space(ibas/DESCRIPTION_2_EN))"/>
<xsl:text>&#xa;</xsl:text>
</xsl:when>
<xsl:when test="(((ibas/DESCRIPTION_1_EN and ibas/DESCRIPTION_2_EN) and (normalize-space(ibas/DESCRIPTION_1_EN) !='') and (normalize-space(ibas/DESCRIPTION_2_EN) ='')) or ((ibas/DESCRIPTION_1_EN and (not(ibas/DESCRIPTION_2_EN))) and (normalize-space(ibas/DESCRIPTION_1_EN) !='' )))">
<xsl:text>title_en=</xsl:text>
<xsl:value-of select="normalize-space(ibas/DESCRIPTION_1_EN)"/>
<xsl:text>&#xa;</xsl:text>
</xsl:when>
<xsl:when test="(((ibas/DESCRIPTION_1_EN and ibas/DESCRIPTION_2_EN) and (normalize-space(ibas/DESCRIPTION_1_EN) ='') and (normalize-space(ibas/DESCRIPTION_2_EN) !='')) or ((not(ibas/DESCRIPTION_1_EN) and (ibas/DESCRIPTION_2_EN)) and (normalize-space(ibas/DESCRIPTION_2_EN) !='' )))">
<xsl:text>title_en=</xsl:text>
<xsl:value-of select="normalize-space(ibas/DESCRIPTION_2_EN)"/>
<xsl:text>&#xa;</xsl:text>
</xsl:when>
<xsl:otherwise>
</xsl:otherwise>
</xsl:choose>
<xsl:choose>
<xsl:when test="(ibas/DESCRIPTION_1_DE and ibas/DESCRIPTION_2_DE) and (normalize-space(ibas/DESCRIPTION_1_DE) !='') and (normalize-space(ibas/DESCRIPTION_2_DE) !='')">
<xsl:text>title_de=</xsl:text>
<xsl:value-of select="concat(normalize-space(ibas/DESCRIPTION_1_DE),'_', normalize-space(ibas/DESCRIPTION_2_DE))"/>
<xsl:text>&#xa;</xsl:text>
</xsl:when>
<xsl:when test="(((ibas/DESCRIPTION_1_DE and ibas/DESCRIPTION_2_DE) and (normalize-space(ibas/DESCRIPTION_1_DE) !='') and (normalize-space(ibas/DESCRIPTION_2_DE) ='')) or ((ibas/DESCRIPTION_1_DE and (not(ibas/DESCRIPTION_2_DE))) and (normalize-space(ibas/DESCRIPTION_1_DE) !='' )))">
<xsl:text>title_de=</xsl:text>
<xsl:value-of select="normalize-space(ibas/DESCRIPTION_1_DE)"/>
<xsl:text>&#xa;</xsl:text>
</xsl:when>
<xsl:when test="(((ibas/DESCRIPTION_1_DE and ibas/DESCRIPTION_2_DE) and (normalize-space(ibas/DESCRIPTION_1_DE) ='') and (normalize-space(ibas/DESCRIPTION_2_DE) !='')) or ((not(ibas/DESCRIPTION_1_DE) and (ibas/DESCRIPTION_2_DE)) and (normalize-space(ibas/DESCRIPTION_2_DE) !='' )))">
<xsl:text>title_de=</xsl:text>
<xsl:value-of select="normalize-space(ibas/DESCRIPTION_2_DE)"/>
<xsl:text>&#xa;</xsl:text>
</xsl:when>
<xsl:otherwise>
</xsl:otherwise>
</xsl:choose>
</xsl:if> 
<xsl:if test="detailURL and normalize-space(detailURL)!=''">
      <xsl:text>info=</xsl:text>
      <xsl:value-of select="normalize-space(detailURL)"/>
      <xsl:text>&#xa;</xsl:text>
</xsl:if>
<xsl:text>-&#xa;</xsl:text>
</xsl:for-each>
  </xsl:template>
</xsl:stylesheet>

