<!--header-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="text" omit-xml-declaration="yes" indent="no"/>
    <xsl:template match="/">
    <!-- End of header-->
      <!--Loop reading attributes of every object in the auto-generated XML created of Windchill-data;
        root/element/items describes the parent structure enclosing the looked for attributes -->
        <xsl:for-each select="root/element/value">
        <!--Narrowing down the data received from Windchill; 
        otherwise all the data received will be processed; 
        both possible if-clauses enclose the following statements;
        they will only end at the end of the file with '</xsl:if>' right above the end of the 'for-each'-loop
        The overall context is found in the tree under 'container' the workspace is defined by 'folder';  
        Two Options: Excluding Objects that shall not be transferred or including those that shall be transferred
        Exclude-option: Use this version if there are other loose objects not assigned to a special folder.
        Just replace the names of the folders between the ''. Data of these Windchill-folders will not be transferred; -->
          <!-- if-clause to select the attribute 'FileName' of every object received from Windchill; in order to define the GT Library attributes 'name' and 'objType'-->
          <xsl:if test="FileName and normalize-space(FileName)!=''">
          <!--Creating a string consisting of 'name=' and 'CADName' of the current object as found in the processed XML followed by a return(&#xa;)-->
            <xsl:text>name=</xsl:text>
            <xsl:value-of select="normalize-space(FileName)"/>
            <xsl:text>&#xa;</xsl:text>
          <!--Creating a string consisting of 'objType=' and a value corresponding to the file extension, defining if the current of object is a drawing, a part etc. followed by a return after the choose process is concluded(&#xa;)
          The 'choose/when' operation differentiates between given file extensions; the 'otherwise' statement after the when-clause sets every not predefined extension to value '-1'-->
            <xsl:text>objType=</xsl:text>
              <xsl:choose> 
                <xsl:when test="contains(FileName,'.asm')"> 
                  <xsl:value-of select="20"/>
                </xsl:when>
                <xsl:when test= "contains(FileName,'.prt')"> 
                  <xsl:value-of select="10"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.drw')"> 
                  <xsl:value-of select="30"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.sec')"> 
                  <xsl:value-of select="40"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.gph')"> 
                  <xsl:value-of select="50"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.mfg')"> 
                  <xsl:value-of select="60"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.lay')"> 
                  <xsl:value-of select="70"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.dgm')"> 
                  <xsl:value-of select="80"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.frm')"> 
                  <xsl:value-of select="90"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.tbl')"> 
                  <xsl:value-of select="100"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.sym')"> 
                  <xsl:value-of select="110"/> 
                </xsl:when>
                <xsl:when test= "contains(FileName,'.txt')"> 
                  <xsl:value-of select="120"/> 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="-1"/> 
                </xsl:otherwise>
              </xsl:choose> 
            <xsl:text>&#xa;</xsl:text>
          </xsl:if>
          <!--creating the path in which library the object is found by concatenating 'wtpub://PDM/Bibliotheken' and the 'folder'-attribute followed by a return-->
          <xsl:if test="FolderLocation and normalize-space(FolderLocation)!=''">
            <xsl:text>path=</xsl:text>
            <xsl:value-of select="concat('wtpub://PDM/Bibliotheken', '/', normalize-space(FolderLocation))"/>  
            <xsl:text>&#xa;</xsl:text>
          </xsl:if>
          <!--creating the parameter 'Revision' as an example parameter. The select chooses the attribute 'version' from which the parameter 'revision' is derived
          Use 'P:PARAMETERNAME=' for every parameter you wish to add and insert the attribute you want to save as this parameter or the concatenation of different attributes; every value has to be followed by a return('&#xa;')-->
          <xsl:if test="Version and normalize-space(Version) !=''">
            <xsl:text>P:REVISION=</xsl:text>
            <xsl:value-of select="normalize-space(Version)"/>
            <xsl:text>&#xa;</xsl:text> 
          </xsl:if>
          <!--another example parameter-->
          <xsl:if test="MATERIAL and normalize-space(MATERIAL)!=''">
            <xsl:text>P:MATERIAL=</xsl:text>
            <xsl:value-of select="normalize-space(MATERIAL)"/>
            <xsl:text>&#xa;</xsl:text> 
          </xsl:if>
          <!--For dimensions use 'D:dimensionname=' and proceed in analogy to the above-->
          <!--deriving the english title/description of the object if defined by the source material; 
          the if section tests if one of 'DESCRIPTION1EN' or 'DESCRIPTION_2_EN' or both are not empty
          the choose/when sections create a string 'title_en=' plus 'DESCRIPTION1EN' or a combination of 'DESCRIPTION1EN' and 'DESCRIPTION_2_EN' or 'DESCRIPTION_2_EN' depending which of those is not empty; in every case the will follow a return, unless both are empty, then it will be ignored-->      
          <xsl:if test="(DESCRIPTION1EN and normalize-space(DESCRIPTION1EN) !='') or (DESCRIPTION2EN and normalize-space(DESCRIPTION2EN) !='')">
            <xsl:choose>
              <xsl:when test="(DESCRIPTION1EN and DESCRIPTION2EN) and (normalize-space(DESCRIPTION1EN) !='') and (normalize-space(DESCRIPTION2EN) !='')">
                <xsl:text>title_en=</xsl:text>
                <xsl:value-of select="concat(normalize-space(DESCRIPTION1EN),'_', normalize-space(DESCRIPTION2EN))"/>
                <xsl:text>&#xa;</xsl:text>
              </xsl:when>
              <xsl:when test="(((DESCRIPTION1EN and DESCRIPTION2EN) and (normalize-space(DESCRIPTION1EN) !='') and (normalize-space(DESCRIPTION2EN) ='')) or ((DESCRIPTION1EN and (not(DESCRIPTION2EN))) and (normalize-space(DESCRIPTION1EN) !='' )))">
                <xsl:text>title_en=</xsl:text>
                <xsl:value-of select="normalize-space(DESCRIPTION1EN)"/>
                <xsl:text>&#xa;</xsl:text>
              </xsl:when>
              <xsl:when test="(((DESCRIPTION1EN and DESCRIPTION2EN) and (normalize-space(DESCRIPTION1EN) ='') and (normalize-space(DESCRIPTION2EN) !='')) or ((not(DESCRIPTION1EN) and (DESCRIPTION2EN)) and (normalize-space(DESCRIPTION2EN) !='' )))">
                <xsl:text>title_en=</xsl:text>
                <xsl:value-of select="normalize-space(DESCRIPTION2EN)"/>
                <xsl:text>&#xa;</xsl:text>
              </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
            </xsl:choose>
          </xsl:if>	
          <!--deriving the german title/description of the object if defined by the source material; 
          the if section tests if 'DESCRIPTION_1_DE' or 'DESCRIPTION_2_DE' or both are not empty
          the choose/when sections create a string 'title_de=' plus 'Description_1_DE' or a combination of 'Description_1_DE' and 'DESCRIPTION_2_DE' or 'DESCRIPTION_2_DE' depending which of those is not empty; in every case the will follow a return, unless both are empty, then it will be ignored-->
          <xsl:if test="(DESCRIPTION1DE and normalize-space(DESCRIPTION1DE) !='') or (DESCRIPTION2DE and normalize-space(DESCRIPTION2DE) !='')">
            <xsl:choose>
              <xsl:when test="(DESCRIPTION1DE and DESCRIPTION2DE) and (normalize-space(DESCRIPTION1DE) !='') and (normalize-space(DESCRIPTION2DE) !='')">
                <xsl:text>title_de=</xsl:text>
                <xsl:value-of select="concat(normalize-space(DESCRIPTION1DE),'_', normalize-space(DESCRIPTION2DE))"/>
                <xsl:text>&#xa;</xsl:text>
              </xsl:when>
              <xsl:when test="(((DESCRIPTION1DE and DESCRIPTION2DE) and (normalize-space(DESCRIPTION1DE) !='') and (normalize-space(DESCRIPTION2DE) ='')) or ((DESCRIPTION1DE and (not(DESCRIPTION2DE))) and (normalize-space(DESCRIPTION1DE) !='' )))">
                <xsl:text>title_de=</xsl:text>
                <xsl:value-of select="normalize-space(DESCRIPTION1DE)"/>
                <xsl:text>&#xa;</xsl:text>
              </xsl:when>
              <xsl:when test="(((DESCRIPTION1DE and DESCRIPTION2DE) and (normalize-space(DESCRIPTION1DE) ='') and (normalize-space(DESCRIPTION2DE) !='')) or ((not(DESCRIPTION1DE) and (DESCRIPTION2DE)) and (normalize-space(DESCRIPTION2DE) !='' )))">
                <xsl:text>title_de=</xsl:text>
                <xsl:value-of select="normalize-space(DESCRIPTION2DE)"/>
                <xsl:text>&#xa;</xsl:text>
              </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
            </xsl:choose>   
          </xsl:if>
          <!--Creating a parameter that enables GTL_DataImporter to detect if the current object has been changed since last last time it was processed-->
          <xsl:if test="State/Value and normalize-space(State/Value)!='' and LastModified">
            <xsl:text>P:WT_CHANGE_ID=</xsl:text>
            <xsl:value-of select="concat(LastModified, ' - ', normalize-space(State/Value))"/>
            <xsl:text>&#xa;</xsl:text> 
          </xsl:if>
          <!--Creating the status attribute checking if the status attribute of the current object is released or not. if not it is set to '0' so it can be processed accordingly with creo/GT_Library -->
          <xsl:if test="State/Value and normalize-space(State/Value)!='RELEASED'">
            <xsl:text>status=</xsl:text>
            <xsl:value-of select="0"/>
            <xsl:text>&#xa;</xsl:text>
          </xsl:if> 
          <!--Creating the attributes 'info' and 'thumbnail' from the Windchill attribute 'id'. NOTICE: 'id' is not part of the 'attributes' branch of the XML tree, therefore the if-clause tests on 'id' AND NOT on 'attributes/id'
          the 'info='-string is concatenating the standardized WINDCHILL-URI for object-ids with the actual id of the current object and an utf8 definition where the ampersand had to be substituted by the code for ampersand to be processed right
          the thumbnail just gets the id itself as a value-->   
          <xsl:if test="ID and normalize-space(ID)!=''">
            <xsl:text>info=</xsl:text>
            <xsl:value-of select="concat('http://wtpdmes02.ratc-de.com:81/Windchill/app/#ptc1/tcomp/infoPage?oid=',normalize-space(ID),'&amp;amp;u8=1')"/>
            <xsl:text>&#xa;</xsl:text>
            <xsl:text>thumbnail=</xsl:text>
            <xsl:value-of select="normalize-space(ID)"/>
            <xsl:text>&#xa;</xsl:text>
          </xsl:if>
                       
          <!--push into tree-->
          <xsl:if test="FolderLocation and normalize-space(FolderLocation)!=''">   
            <xsl:text>tree=</xsl:text>
            <xsl:call-template name="substring-after-last">
    				  <xsl:with-param name="string" select="normalize-space(FolderLocation)"/> 
    				  <xsl:with-param name="delimiter" select="'/'"/>
    			  </xsl:call-template>     
            <xsl:text>&#xa;</xsl:text>
          </xsl:if>
        
        <!--final '-' and return to indicate the end of a single object; necessary for DataImporter to distinguish the two objects while processing all the data as a string-->
      <xsl:text>-&#xa;</xsl:text>
    </xsl:for-each>
  </xsl:template>
  
  
  <xsl:template name="substring-after-last">
    <xsl:param name="string"/>
    <xsl:param name="delimiter"/>
    
    <xsl:choose>
      <xsl:when test="contains($string, $delimiter)">
        <xsl:call-template name="substring-after-last">
          <xsl:with-param name="string" select="substring-after($string, $delimiter)"/>
          <xsl:with-param name="delimiter" select="$delimiter"/>
        </xsl:call-template> 
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$string" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>                                                                     
</xsl:stylesheet> 

