<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>
<xsl:template match="/">
    <xsl:for-each select="files/file">
      <xsl:if test="name and normalize-space(name)!=''">
        <xsl:text>name=</xsl:text>
        <xsl:value-of select="normalize-space(name)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>	
	  <xsl:if test="tree and normalize-space(tree)!=''">
        <xsl:text>tree=</xsl:text>
        <xsl:value-of select="normalize-space(tree)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>		  
      <xsl:if test="path and normalize-space(path)!=''">
        <xsl:text>path=</xsl:text>
        <xsl:value-of select="normalize-space(path)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="objType and normalize-space(objType)!=''">
        <xsl:text>objType=</xsl:text>
        <xsl:value-of select="normalize-space(objType)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="thumbnail and normalize-space(thumbnail)!=''">
        <xsl:text>thumbnail=</xsl:text>
        <xsl:value-of select="normalize-space(thumbnail)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>	 
      <xsl:if test="status and normalize-space(status)!=''">
        <xsl:text>status=</xsl:text>
        <xsl:value-of select="normalize-space(status)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="title_de and normalize-space(title_de)!=''">
        <xsl:text>title_de=</xsl:text>
        <xsl:value-of select="normalize-space(title_de)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="title_en and normalize-space(title_en)!=''">
        <xsl:text>title_en=</xsl:text>
        <xsl:value-of select="normalize-space(title_en)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="title_es and normalize-space(title_es)!=''">
        <xsl:text>title_es=</xsl:text>
        <xsl:value-of select="normalize-space(title_es)"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
	  <xsl:if test="P[@key='MASSE'] and normalize-space(P[@key='MASSE'])!=''">
        <xsl:text>P:MASSE=</xsl:text>
        <xsl:value-of select="normalize-space(P[@key='MASSE'])"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="P[@key='FORM'] and normalize-space(P[@key='FORM'])!=''">
        <xsl:text>P:FORM=</xsl:text>
        <xsl:value-of select="normalize-space(P[@key='FORM'])"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="P[@key='WT_CHANGE_ID'] and normalize-space(P[@key='WT_CHANGE_ID'])!=''">
        <xsl:text>P:WT_CHANGE_ID=</xsl:text>
        <xsl:value-of select="normalize-space(P[@key='WT_CHANGE_ID'])"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="P[@key='TOLERANZ'] and normalize-space(P[@key='TOLERANZ'])!=''">
        <xsl:text>P:TOLERANZ=</xsl:text>
        <xsl:value-of select="normalize-space(P[@key='TOLERANZ'])"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="D[@key='XMLDIM1'] and normalize-space(D[@key='XMLDIM1'])!=''">
        <xsl:text>D:XMLDIM1=</xsl:text>
        <xsl:value-of select="normalize-space(D[@key='XMLDIM1'])"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="D[@key='XMLDIM2'] and normalize-space(D[@key='XMLDIM2'])!=''">
        <xsl:text>D:XMLDIM2=</xsl:text>
        <xsl:value-of select="normalize-space(D[@key='XMLDIM2'])"/>
      <xsl:text>&#xa;</xsl:text> 
      </xsl:if>
      <xsl:if test="info and normalize-space(info)!=''">
        <xsl:text>info=</xsl:text>
        <xsl:value-of select="normalize-space(info)"/>
		<xsl:text>&#xa;</xsl:text>
      </xsl:if>
	  <xsl:text>-</xsl:text>
	  <xsl:text>&#xa;</xsl:text>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>